/*
 * Decompiled with CFR 0.152.
 */
package us.k5n.webcalendar;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import us.k5n.webcalendar.EventDisplayer;
import us.k5n.webcalendar.EventList;
import us.k5n.webcalendar.WebCalendarClient;
import us.k5n.webcalendar.WebCalendarErrorException;

public class EventLoader
extends Thread {
    private WebCalendarClient client;
    URL url;
    String username;
    String password;
    EventDisplayer display = null;
    Calendar startDate = null;
    Calendar endDate = null;

    public EventLoader(WebCalendarClient webCalendarClient, EventDisplayer eventDisplayer) {
        this.client = webCalendarClient;
        this.display = eventDisplayer;
        this.startDate = Calendar.getInstance();
        this.endDate = Calendar.getInstance();
    }

    public EventList getEvents() {
        try {
            String string = this.client.getEvents(this.startDate, this.endDate);
            if (string.indexOf("<events>") >= 0) {
                EventList eventList = new EventList(string, "events");
                return eventList;
            }
            this.client.getMessageDisplayer().showError("Invalid data returned from server:\n\n" + string);
        }
        catch (MalformedURLException malformedURLException) {
            if (malformedURLException.toString().indexOf("login.php") >= 0) {
                this.client.getMessageDisplayer().showError("WebCalendar login required");
            } else {
                this.client.getMessageDisplayer().showError("Error getting data from server:\n" + malformedURLException.toString());
            }
        }
        catch (WebCalendarErrorException webCalendarErrorException) {
            System.err.println("WebCalendar Error: " + webCalendarErrorException.getMessage());
            this.client.getMessageDisplayer().showError("WebCalendar Error:\n" + webCalendarErrorException.getMessage());
        }
        catch (Exception exception) {
            System.err.println("Exception getting reminders: " + exception.toString());
            exception.printStackTrace();
            if (exception.toString().indexOf("401") >= 0) {
                this.client.getMessageDisplayer().showError("Server requires HTTP authorization:\n" + exception.toString());
            }
            this.client.getMessageDisplayer().showError("Error getting data from server:\n" + exception.toString());
        }
        return null;
    }

    public void setStartDate(Calendar calendar) {
        this.startDate = calendar;
    }

    public void setEndDate(Calendar calendar) {
        this.endDate = calendar;
    }

    public void run() {
        while (true) {
            EventList eventList;
            if ((eventList = this.getEvents()) != null) {
                this.display.storeEvents(eventList);
            }
            try {
                Thread.currentThread();
                Thread.sleep(1471228928L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }
}

