/*
 * Decompiled with CFR 0.152.
 */
package us.k5n.webcalendar.ui.ControlPanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import us.k5n.webcalendar.ActivityLogList;
import us.k5n.webcalendar.WebCalendarClient;
import us.k5n.webcalendar.ui.ControlPanel.ReadOnlyTable;

public class ActivityLogPanel
extends JPanel {
    WebCalendarClient client;
    private ReadOnlyTable table = null;
    private JScrollPane scrollPane;
    private Vector colHeader = null;
    private ActivityLogList list = null;

    public ActivityLogPanel(WebCalendarClient webCalendarClient) {
        this.client = webCalendarClient;
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        JButton jButton = new JButton("Refresh");
        jPanel.add(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActivityLogPanel.this.updateActivtyLogTable();
            }
        });
        this.add((Component)jPanel, "South");
        ActivityLogList activityLogList = null;
        try {
            String string = webCalendarClient.query("ws/activity_log.php?num=500");
            if (string.indexOf("<activitylog>") < 0) {
                System.err.println("Invalid activity log XML:\n" + string);
            } else {
                activityLogList = new ActivityLogList(string, "activitylog");
            }
        }
        catch (Exception exception) {
            System.err.println("Exception getting activity log: " + exception);
            exception.printStackTrace();
        }
        this.colHeader = new Vector();
        this.colHeader.add("User");
        this.colHeader.add("Calendar");
        this.colHeader.add("Date");
        this.colHeader.add("Action");
        this.colHeader.add("Event");
        this.scrollPane = new JScrollPane();
        this.add((Component)this.scrollPane, "Center");
        this.updateActivtyLogTable();
    }

    public void updateActivtyLogTable() {
        try {
            String string = this.client.query("ws/activity_log.php?num=500");
            if (string.indexOf("<activitylog>") < 0) {
                System.err.println("Invalid activity log XML:\n" + string);
            } else {
                this.list = new ActivityLogList(string, "activitylog");
            }
        }
        catch (Exception exception) {
            System.err.println("Exception getting events: " + exception);
            this.showError("Exception getting events:\n\n" + exception.getMessage());
            exception.printStackTrace();
        }
        if (this.table != null) {
            this.scrollPane.remove(this.table);
        }
        this.table = this.list != null ? new ReadOnlyTable((Vector)this.list, this.colHeader) : new ReadOnlyTable(new Vector(), this.colHeader);
        this.table.doLayout();
        this.scrollPane.setViewportView(this.table);
    }

    private void showError(String string) {
        JOptionPane.showMessageDialog(this, string, "Error", 2);
    }
}

