/*
 * Decompiled with CFR 0.152.
 */
package us.k5n.webcalendar.ui.ControlPanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import us.k5n.webcalendar.User;
import us.k5n.webcalendar.WebCalendarClient;
import us.k5n.webcalendar.ui.ControlPanel.UserListener;

public class UserDialog
extends JDialog {
    WebCalendarClient client = null;
    JFrame parent = null;
    static final int EDIT_MODE = 1;
    static final int ADD_MODE = 2;
    int mode;
    JTextField username;
    JTextField firstname;
    JTextField lastname;
    JTextField fullname;
    JTextField email;
    JPasswordField password1;
    JPasswordField password2;
    JComboBox userType;
    UserListener userListener = null;

    public UserDialog(WebCalendarClient webCalendarClient, JFrame jFrame, int n, UserListener userListener) {
        this(webCalendarClient, jFrame, n, userListener, null);
    }

    public UserDialog(WebCalendarClient webCalendarClient, JFrame jFrame, int n, UserListener userListener, User user) {
        super(jFrame, n == 1 ? "Edit User" : "Add User", true);
        this.client = webCalendarClient;
        this.userListener = userListener;
        this.mode = n;
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("Ok");
        jPanel.add(jButton);
        this.getContentPane().add((Component)jPanel, "South");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (UserDialog.this.mode == 2 && !UserDialog.this.password1.getText().equals(UserDialog.this.password2.getText())) {
                    UserDialog.this.client.showError("Passwords do not match");
                } else if (UserDialog.this.username.getText().length() == 0) {
                    UserDialog.this.client.showError("You must enter a username");
                } else if (UserDialog.this.mode == 2 && UserDialog.this.password1.getText().length() == 0) {
                    UserDialog.this.client.showError("You must enter a password");
                } else if (UserDialog.this.mode == 2 && UserDialog.this.client.addUser(UserDialog.this.getUser())) {
                    UserDialog.this.userListener.updateUserList();
                    UserDialog.this.hide();
                    UserDialog.this.dispose();
                } else if (UserDialog.this.mode == 1 && UserDialog.this.client.updateUser(UserDialog.this.getUser())) {
                    UserDialog.this.userListener.updateUserList();
                    UserDialog.this.hide();
                    UserDialog.this.dispose();
                }
            }
        });
        JButton jButton2 = new JButton("Cancel");
        jPanel.add(jButton2);
        this.getContentPane().add((Component)jPanel, "South");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UserDialog.this.hide();
                UserDialog.this.dispose();
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(this.mode == 2 ? 7 : 5, 2));
        jPanel2.setBorder(BorderFactory.createTitledBorder(this.mode == 2 ? "Add User" : "Edit User"));
        jPanel2.add(new JLabel("User login: "));
        this.username = new JTextField(25);
        this.username.setName("username");
        if (this.mode == 1) {
            if (user != null && user.login != null) {
                this.username.setText(user.login);
            }
            this.username.setEditable(false);
        }
        jPanel2.add(this.username);
        jPanel2.add(new JLabel("First name: "));
        this.firstname = new JTextField(15);
        this.firstname.setName("firstname");
        if (this.mode == 1 && user.firstName != null) {
            this.firstname.setText(user.firstName);
        }
        jPanel2.add(this.firstname);
        jPanel2.add(new JLabel("Last name: "));
        this.lastname = new JTextField(15);
        this.lastname.setName("lastname");
        if (this.mode == 1 && user.lastName != null) {
            this.lastname.setText(user.lastName);
        }
        jPanel2.add(this.lastname);
        jPanel2.add(new JLabel("Email: "));
        this.email = new JTextField(25);
        if (this.mode == 1 && user.email != null) {
            this.email.setText(user.email);
        }
        jPanel2.add(this.email);
        if (this.mode == 2) {
            jPanel2.add(new JLabel("Password: "));
            this.password1 = new JPasswordField(25);
            this.password1.setEchoChar('*');
            jPanel2.add(this.password1);
            jPanel2.add(new JLabel("Password (confirm): "));
            this.password2 = new JPasswordField(25);
            this.password2.setEchoChar('*');
            jPanel2.add(this.password2);
        }
        Vector<String> vector = new Vector<String>();
        vector.addElement("User");
        vector.addElement("Administrator");
        jPanel2.add(new JLabel("User type: "));
        this.userType = new JComboBox(vector);
        jPanel2.add(this.userType);
        this.getContentPane().add((Component)jPanel2, "Center");
        this.pack();
        this.show();
    }

    public User getUser() {
        User user = new User(this.username.getText());
        user.firstName = this.firstname.getText();
        user.lastName = this.lastname.getText();
        user.password = this.password1 != null ? this.password1.getText() : null;
        user.email = this.email.getText();
        Object object = this.userType.getSelectedItem();
        user.isAdmin = object != null && object.toString().toLowerCase().startsWith("admin");
        return user;
    }
}

