/*
 * Decompiled with CFR 0.152.
 */
package us.k5n.webcalendar;

import java.io.IOException;
import java.io.StringBufferInputStream;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import us.k5n.webcalendar.Reminder;
import us.k5n.webcalendar.Utils;
import us.k5n.webcalendar.WebCalendarErrorException;
import us.k5n.webcalendar.WebCalendarParseException;

public class ReminderList
extends Vector {
    Document document;

    public ReminderList(String string) throws WebCalendarParseException, WebCalendarErrorException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            StringBufferInputStream stringBufferInputStream = new StringBufferInputStream(string);
            this.document = documentBuilder.parse(stringBufferInputStream);
            this.domToReminders(this.document);
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
            System.err.println("XML:\n" + string + "[end xml]");
            throw new WebCalendarParseException("Error parsing XML from WebCalendar server: " + exception.toString());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new WebCalendarParseException("I/O Error parsing XML from WebCalendar server: " + iOException.toString());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            throw new WebCalendarParseException("Parser Config Error parsing XML from WebCalendar server: " + parserConfigurationException.toString());
        }
    }

    private void domToReminders(Document document) throws WebCalendarParseException, WebCalendarErrorException {
        String string = Utils.getError(document);
        if (string != null) {
            throw new WebCalendarErrorException(string);
        }
        NodeList nodeList = document.getElementsByTagName("reminders");
        if (nodeList.getLength() < 1) {
            System.err.println("No <reminders> found");
            throw new WebCalendarParseException("No <reminders> tag found in XML");
        }
        if (nodeList.getLength() > 1) {
            System.err.println("Too many <reminders> found (" + nodeList.getLength() + ")");
            throw new WebCalendarParseException("Too many <reminders> found (" + nodeList.getLength() + ")");
        }
        Node node = nodeList.item(0);
        nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            if ("reminder".equals(node2.getNodeName())) {
                this.addElement(new Reminder(node2));
                continue;
            }
            System.err.println("Not sure what to do with <" + node2.getNodeName() + "> tag (expecting <reminder>... ignoring)");
        }
    }
}

