/*
 * Decompiled with CFR 0.152.
 */
package us.k5n.webcalendar.ui.ControlPanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.StringBufferInputStream;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import us.k5n.webcalendar.Event;
import us.k5n.webcalendar.EventList;
import us.k5n.webcalendar.Participant;
import us.k5n.webcalendar.Utils;
import us.k5n.webcalendar.WebCalendarClient;
import us.k5n.webcalendar.WebCalendarErrorException;
import us.k5n.webcalendar.WebCalendarParseException;
import us.k5n.webcalendar.ui.ControlPanel.EventVector;
import us.k5n.webcalendar.ui.ControlPanel.ReadOnlyTable;

public class UnapprovedEventsPanel
extends JPanel {
    ReadOnlyTable table;
    WebCalendarClient client;
    Vector events = null;
    private JScrollPane scrollPane;

    public UnapprovedEventsPanel(WebCalendarClient webCalendarClient) {
        this.client = webCalendarClient;
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        JButton jButton = new JButton("Refresh");
        jPanel.add(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UnapprovedEventsPanel.this.updateEventList();
            }
        });
        final JButton jButton2 = new JButton("Approve");
        jPanel.add(jButton2);
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = UnapprovedEventsPanel.this.table.getSelectedRows();
                if (nArray.length == 0) {
                    UnapprovedEventsPanel.this.showError("You must select an event.");
                } else if (nArray.length > 1) {
                    UnapprovedEventsPanel.this.showError("You must select\nonly one event.");
                } else {
                    EventVector eventVector = (EventVector)UnapprovedEventsPanel.this.events.elementAt(nArray[0]);
                    Object[] objectArray = new String[]{"Approve", "Cancel"};
                    int n = JOptionPane.showOptionDialog(jButton2.getParent(), "Are you sure you want to\napprove the following event\nfor user " + eventVector.getParticipant().getDisplayLogin() + "?\n\n" + eventVector.toString(), "Confirm", 0, 3, null, objectArray, objectArray[1]);
                    if (n == 0) {
                        UnapprovedEventsPanel.this.approveEvent(eventVector);
                    }
                }
            }
        });
        final JButton jButton3 = new JButton("Reject");
        jPanel.add(jButton3);
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = UnapprovedEventsPanel.this.table.getSelectedRows();
                if (nArray.length == 0) {
                    UnapprovedEventsPanel.this.showError("You must select an event.");
                } else if (nArray.length > 1) {
                    UnapprovedEventsPanel.this.showError("You must select\nonly one event.");
                } else {
                    EventVector eventVector = (EventVector)UnapprovedEventsPanel.this.events.elementAt(nArray[0]);
                    Object[] objectArray = new String[]{"Reject", "Cancel"};
                    int n = JOptionPane.showOptionDialog(jButton3.getParent(), "Are you sure you want to\nreject the following event\nfor user " + eventVector.getParticipant().getDisplayLogin() + "?\n\n" + eventVector.toString(), "Confirm", 0, 3, null, objectArray, objectArray[1]);
                    if (n == 0) {
                        UnapprovedEventsPanel.this.rejectEvent(eventVector);
                    }
                }
            }
        });
        final JButton jButton4 = new JButton("Delete");
        jPanel.add(jButton4);
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = UnapprovedEventsPanel.this.table.getSelectedRows();
                if (nArray.length == 0) {
                    UnapprovedEventsPanel.this.showError("You must select at\nleast one event.");
                } else if (nArray.length > 1) {
                    UnapprovedEventsPanel.this.showError("You must select\nonly one event.");
                } else {
                    EventVector eventVector = (EventVector)UnapprovedEventsPanel.this.events.elementAt(nArray[0]);
                    Object[] objectArray = new String[]{"Delete", "Cancel"};
                    int n = JOptionPane.showOptionDialog(jButton4.getParent(), "Are you sure you want to\ndelete the following event\nfor user " + eventVector.getParticipant().getDisplayLogin() + "?\n\n" + eventVector.toString(), "Confirm", 0, 3, null, objectArray, objectArray[1]);
                    if (n == 0) {
                        UnapprovedEventsPanel.this.deleteEvent(eventVector);
                    }
                }
            }
        });
        this.add((Component)jPanel, "South");
        this.scrollPane = new JScrollPane();
        this.updateEventList();
        this.table.setSelectionMode(0);
        this.add((Component)this.scrollPane, "Center");
    }

    private void showError(String string) {
        JOptionPane.showMessageDialog(this, string, "Error", 2);
    }

    private void deleteEvent(EventVector eventVector) {
        if (!this.client.deleteEvent(eventVector.getEvent(), eventVector.getParticipant())) {
            this.showError("Error deleting event");
        }
        this.updateEventList();
    }

    private void approveEvent(EventVector eventVector) {
        if (!this.client.approveEvent(eventVector.getEvent(), eventVector.getParticipant())) {
            this.showError("Error approving event");
        }
        this.updateEventList();
    }

    private void rejectEvent(EventVector eventVector) {
        if (!this.client.rejectEvent(eventVector.getEvent(), eventVector.getParticipant())) {
            this.showError("Error rejecting event");
        }
        this.updateEventList();
    }

    public void updateEventList() {
        try {
            String string = this.client.query("ws/get_unapproved.php");
            EventList eventList = new EventList(string, "events");
            HashMap hashMap = this.userListForApprove(string, "userlist");
            this.events = this.eventListToVector(eventList, hashMap);
        }
        catch (Exception exception) {
            System.err.println("Exception getting events: " + exception);
            this.showError("Exception getting events:\n\n" + exception.getMessage());
            exception.printStackTrace();
        }
        if (this.table != null) {
            this.scrollPane.remove(this.table);
        }
        this.table = this.events != null ? new ReadOnlyTable(this.events, EventVector.getHeader()) : new ReadOnlyTable(new Vector(), EventVector.getHeader());
        this.table.doLayout();
        this.scrollPane.setViewportView(this.table);
    }

    private Vector eventListToVector(EventList eventList, HashMap hashMap) {
        Vector<EventVector> vector = new Vector<EventVector>();
        for (int i = 0; i < eventList.size(); ++i) {
            Event event = eventList.eventAt(i);
            Vector vector2 = event.getParticipants();
            for (int j = 0; j < vector2.size(); ++j) {
                Participant participant = (Participant)vector2.elementAt(j);
                if (hashMap.containsKey(participant.getLogin())) {
                    if (participant.getStatus() == null || !participant.getStatus().equalsIgnoreCase("W")) continue;
                    EventVector eventVector = new EventVector(event, participant);
                    vector.addElement(eventVector);
                    continue;
                }
                System.out.println("Ignoring participant '" + participant.getLogin() + "' since this user cannot approve for them.");
            }
        }
        return vector;
    }

    private HashMap userListForApprove(String string, String string2) throws WebCalendarParseException, WebCalendarErrorException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            StringBufferInputStream stringBufferInputStream = new StringBufferInputStream(string);
            Document document = documentBuilder.parse(stringBufferInputStream);
            return this.domToUserHashMap(document, string2);
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
            System.err.println("XML:\n" + string + "\n[end xml]");
            throw new WebCalendarParseException("Error parsing XML from WebCalendar server: " + exception.toString());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new WebCalendarParseException("I/O Error parsing XML from WebCalendar server: " + iOException.toString());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            throw new WebCalendarParseException("Parser Config Error parsing XML from WebCalendar server: " + parserConfigurationException.toString());
        }
    }

    private HashMap domToUserHashMap(Document document, String string) throws WebCalendarParseException, WebCalendarErrorException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string2 = Utils.getError(document);
        if (string2 != null) {
            throw new WebCalendarErrorException(string2);
        }
        NodeList nodeList = document.getElementsByTagName(string);
        if (nodeList.getLength() < 1) {
            System.err.println("No <" + string + "> found");
            throw new WebCalendarParseException("No <" + string + "> tag found in XML");
        }
        if (nodeList.getLength() > 1) {
            System.err.println("Too many <" + string + "> found (" + nodeList.getLength() + ")");
            throw new WebCalendarParseException("Too many <" + string + "> found (" + nodeList.getLength() + ")");
        }
        Node node = nodeList.item(0);
        nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            if ("login".equals(node2.getNodeName())) {
                String string3 = Utils.xmlNodeGetValue(node2);
                hashMap.put(string3, string3);
                continue;
            }
            System.err.println("Not sure what to do with <" + node2.getNodeName() + "> tag (expecting <login>... ignoring) in <" + string + ">");
        }
        return hashMap;
    }
}

